/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.CustomItemProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSlabBlock
extends SlabBlock
implements BlockModelProvider,
CustomItemProvider,
TagProvider,
DropSelfLootProvider<BaseSlabBlock> {
    private final Block parent;
    public final boolean fireproof;

    protected BaseSlabBlock(Block source, boolean fireproof) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source));
        this.parent = source;
        this.fireproof = fireproof;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.m_49966_());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation blockId, BlockState blockState) {
        ResourceLocation parentId = BuiltInRegistries.f_256975_.m_7981_((Object)this.parent);
        Optional<String> pattern = blockState.m_61143_((Property)f_56353_) == SlabType.DOUBLE ? PatternsHelper.createBlockSimple(parentId) : PatternsHelper.createJson(BasePatterns.BLOCK_SLAB, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        SlabType type = (SlabType)blockState.m_61143_((Property)f_56353_);
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + "_" + type);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        if (type == SlabType.TOP) {
            return ModelsHelper.createMultiVariant(modelId, BlockModelRotation.X180_Y0.m_6189_(), true);
        }
        return ModelsHelper.createBlockSimple(modelId);
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13031_);
        itemTags.add((TagKey<Item>)ItemTags.f_13139_);
    }

    @Override
    public BlockItem getCustomItem(ResourceLocation blockID, Item.Properties settings) {
        if (this.fireproof) {
            settings = settings.m_41486_();
        }
        return new BlockItem((Block)this, settings);
    }

    public static BaseSlabBlock from(Block source, boolean flammable) {
        return BehaviourHelper.from(source, s -> new Wood((Block)s, !flammable), s -> new Stone((Block)s, !flammable), s -> new Metal((Block)s, !flammable), s -> new Obsidian((Block)s, !flammable), null);
    }

    public static class Obsidian
    extends BaseSlabBlock
    implements BehaviourObsidian {
        public Obsidian(Block source) {
            super(source, true);
        }

        public Obsidian(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Metal
    extends BaseSlabBlock
    implements BehaviourMetal {
        public Metal(Block source) {
            this(source, true);
        }

        public Metal(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Stone
    extends BaseSlabBlock
    implements BehaviourStone {
        public Stone(Block source) {
            this(source, true);
        }

        public Stone(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Wood
    extends BaseSlabBlock
    implements BehaviourWood {
        public Wood(Block source) {
            this(source, false);
        }

        public Wood(Block source, boolean fireproof) {
            super(source, fireproof);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13097_);
            itemTags.add((TagKey<Item>)ItemTags.f_13175_);
        }
    }
}

